<?php $__env->startSection('header.title'); ?>
Better Work Indonesia | My Attendance Data
<?php $__env->stopSection(); ?>
<?php $__env->startSection('header.plugins'); ?>
<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/plugins/datatables-bs4/css/dataTables.bootstrap4.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('bower_components/admin-lte/plugins/daterangepicker/daterangepicker.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<section class="content-header">
	<div class="container-fluid">
    <div class="row mb-2">
    	<div class="col-sm-6">
     		<h1>My Attendance Data</h1>
    	</div>
    </div>
  </div>
</section>
<section class="content">
	<div class="row">
		<div class="col-12">
			<div class="card card-primary card-outline">
				<div class="card-header">
					<?php echo Form::open(array('route' => 'myAttendance.search','method'=>'POST')); ?>

					<?php echo csrf_field(); ?>
					<div class="row">
						<div class="col-3">
							<div class="input-group">
								<div class="input-group-prepend">
									<span class="input-group-text">
										<i class="far fa-calendar-alt"></i>
									</span>
								</div>
								<input type="text" name="date_range" class="form-control float-right" id="reservation">
							</div>
						</div>
						<div class="col-3">
							<button type="submit" class="btn btn-sm btn-success">Search</button>
							<a button type="button" class="btn btn-sm btn-danger" href="<?php echo e(route('myAttendance.index')); ?>">Cancel</a>
						</div>
					</div>
					<?php echo Form::close(); ?>

				</div>
				<div class="card-body">
					<table id="example2" class="table table-bordered table-hover">
						<thead>
							<tr>
								<th>No</th>
								<th>Date</th>
								<th>Clock In</th>
								<th>Clock Out</th>
								<th>Notes</th>
								<th>Status</th>
							</tr>
						</thead>
						<tbody>
							<?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<tr>
								<td><?php echo e($key+1); ?></td>
								<td><?php echo e(date("d F Y",strtotime($value->created_at))); ?></td>
								<td><?php echo e(date("H:i",strtotime($value->clock_in))); ?></td>
								<td>
									<?php if(!empty($value->clock_out)): ?>
									<?php echo e(date("H:i",strtotime($value->clock_out))); ?>

									<?php endif; ?>
								</td>
								<td><?php echo e($value->notes); ?></td>
								<td>
									<?php if(($value->status_id) == 'f4f23f41-0588-4111-a881-a043cf355831'): ?>
									<span class="badge badge-danger"><?php echo e($value->Statuses->name); ?></span>
									<?php else: ?>
									<span class="badge badge-success"><?php echo e($value->Statuses->name); ?></span>
									<?php endif; ?>
								</td>
							</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</tbody>
					</table>
				</div>
			</div>
		</div>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('footer.scripts'); ?>
<script src="<?php echo e(asset('bower_components/admin-lte/plugins/datatables/jquery.dataTables.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/admin-lte/plugins/datatables-bs4/js/dataTables.bootstrap4.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/admin-lte/plugins/moment/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('bower_components/admin-lte/plugins/daterangepicker/daterangepicker.js')); ?>"></script>
<script>
  $(function () {
    $("#example1").DataTable();
    $('#example2').DataTable({
      "paging": true,
      "lengthChange": false,
      "searching": false,
      "ordering": true,
      "info": true,
      "autoWidth": false,
    });
    $('#reservation').daterangepicker()
  });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('apps.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\betterwork-master\resources\views/apps/pages/myAttendance.blade.php ENDPATH**/ ?>